<?php
// /public_html/api/assets/toggle.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('POST');
$body = read_json_body();

$id = (int)($body['id'] ?? 0);
$is_active = (int)($body['is_active'] ?? 1);

if ($id <= 0) json_out(['success' => false, 'message' => 'Missing id.'], 400);
$is_active = $is_active ? 1 : 0;

$stmt = $con->prepare("UPDATE assets SET is_active=? WHERE id=?");
if (!$stmt) json_out(['success' => false, 'message' => 'DB prepare failed.'], 500);
$stmt->bind_param('ii', $is_active, $id);
$stmt->execute();
$affected = $stmt->affected_rows;
$stmt->close();

json_out(['success' => true, 'affected' => $affected, 'is_active' => $is_active]);