<?php
// /public_html/api/assets/upload.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('POST');

$name = trim((string)($_POST['name'] ?? ''));
$category = trim((string)($_POST['category'] ?? 'General'));
$tags = trim((string)($_POST['tags'] ?? ''));

$width_mm  = $_POST['width_mm'] ?? null;
$height_mm = $_POST['height_mm'] ?? null;

$width_mm = clamp_dec($width_mm, 0.001, 100000, 0);
$height_mm = clamp_dec($height_mm, 0.001, 100000, 0);

if ($name === '') json_out(['success' => false, 'message' => 'Missing name.'], 400);
if ($width_mm <= 0 || $height_mm <= 0) json_out(['success' => false, 'message' => 'Invalid width_mm/height_mm.'], 400);

if (!isset($_FILES['file'])) json_out(['success' => false, 'message' => 'Missing file.'], 400);

$allowed = ['image/png', 'image/svg+xml'];

$origName = safe_filename((string)($_FILES['file']['name'] ?? 'asset'));
$ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
if (!in_array($ext, ['png','svg'], true)) $ext = 'png';

// First insert DB row with placeholder path
$stmt = $con->prepare("INSERT INTO assets (name, category, tags, file_path, width_mm, height_mm, mime_type, is_active) VALUES (?, ?, ?, '', ?, ?, '', 1)");
if (!$stmt) json_out(['success' => false, 'message' => 'DB prepare failed.'], 500);

$stmt->bind_param('sssdd', $name, $category, $tags, $width_mm, $height_mm);
$ok = $stmt->execute();
$asset_id = $ok ? (int)$stmt->insert_id : 0;
$stmt->close();

if (!$ok || $asset_id <= 0) json_out(['success' => false, 'message' => 'Failed to create asset row.'], 500);

$assetDirAbs = UPLOAD_ROOT . "/assets/{$asset_id}";
ensure_dir($assetDirAbs);

$destAbs = $assetDirAbs . "/asset." . $ext;

$move = move_uploaded_file_validated($_FILES['file'], $allowed, $destAbs);
if (!$move['ok']) {
  // cleanup
  $con->query("DELETE FROM assets WHERE id = " . (int)$asset_id);
  json_out(['success' => false, 'message' => $move['message'] ?? 'Upload failed.'], 400);
}

$mime = $move['mime'] ?? detect_mime($destAbs);

// SVG safety: best-effort strip risk is complex; for v1, reject if it contains script/onload.
if ($mime === 'image/svg+xml') {
  $svg = @file_get_contents($destAbs);
  if ($svg === false) {
    $con->query("DELETE FROM assets WHERE id = " . (int)$asset_id);
    @unlink($destAbs);
    json_out(['success' => false, 'message' => 'Failed to read SVG.'], 400);
  }
  $lower = strtolower($svg);
  if (strpos($lower, '<script') !== false || strpos($lower, 'onload=') !== false || strpos($lower, 'javascript:') !== false) {
    $con->query("DELETE FROM assets WHERE id = " . (int)$asset_id);
    @unlink($destAbs);
    json_out(['success' => false, 'message' => 'SVG contains disallowed content.'], 400);
  }
}

$file_path = URL_UPLOADS_PREFIX . "/assets/{$asset_id}/asset." . $ext;

$stmt = $con->prepare("UPDATE assets SET file_path = ?, mime_type = ? WHERE id = ?");
if (!$stmt) json_out(['success' => false, 'message' => 'DB prepare failed (update).'], 500);
$stmt->bind_param('ssi', $file_path, $mime, $asset_id);
$stmt->execute();
$stmt->close();

json_out([
  'success' => true,
  'asset_id' => $asset_id,
  'file_path' => $file_path,
  'mime_type' => $mime
]);