<?php
// /public_html/api/background/upload.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('POST');

$token = (string)($_POST['token'] ?? '');
$mode  = (string)($_POST['mode'] ?? 'straight');

$mode = strtolower(trim($mode));
if (!in_array($mode, ['straight','perspective'], true)) $mode = 'straight';

$project = resolve_project_by_token($con, $token);
$project_id = (int)$project['id'];

if (!isset($_FILES['file'])) json_out(['success' => false, 'message' => 'Missing file.'], 400);

$allowed = ['image/jpeg','image/png','image/webp'];

$origName = safe_filename((string)($_FILES['file']['name'] ?? 'background'));
$ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
if (!in_array($ext, ['jpg','jpeg','png','webp'], true)) $ext = 'jpg';

$bgDirAbs = UPLOAD_ROOT . "/projects/{$project_id}/background";
ensure_dir($bgDirAbs);

$destAbs = $bgDirAbs . "/original." . $ext;
$move = move_uploaded_file_validated($_FILES['file'], $allowed, $destAbs);
if (!$move['ok']) json_out(['success' => false, 'message' => $move['message'] ?? 'Upload failed.'], 400);

$mime = $move['mime'] ?? detect_mime($destAbs);

// Get dimensions (best-effort)
$w = null; $h = null;
$info = @getimagesize($destAbs);
if (is_array($info)) { $w = (int)($info[0] ?? 0); $h = (int)($info[1] ?? 0); }
if ($w <= 0) $w = null;
if ($h <= 0) $h = null;

$original_path = URL_UPLOADS_PREFIX . "/projects/{$project_id}/background/original." . $ext;

$stmt = $con->prepare("
  INSERT INTO project_backgrounds (project_id, original_path, mode, width_px, height_px)
  VALUES (?, ?, ?, ?, ?)
");
if (!$stmt) json_out(['success' => false, 'message' => 'DB prepare failed.'], 500);

$stmt->bind_param('issii', $project_id, $original_path, $mode, $w, $h);
$ok = $stmt->execute();
$bg_id = $ok ? (int)$stmt->insert_id : 0;
$stmt->close();

if (!$ok || $bg_id <= 0) json_out(['success' => false, 'message' => 'DB insert failed.'], 500);

json_out([
  'success' => true,
  'background_id' => $bg_id,
  'original_path' => $original_path,
  'mode' => $mode,
  'width_px' => $w,
  'height_px' => $h,
  'mime_type' => $mime
]);