<?php
// /public_html/api/export/save.php
require_once __DIR__ . '/../_bootstrap.php';

require_method('POST');

$token = (string)($_POST['token'] ?? '');
$type  = strtolower(trim((string)($_POST['export_type'] ?? 'after')));
if (!in_array($type, ['before','after'], true)) $type = 'after';

$project = resolve_project_by_token($con, $token);
$project_id = (int)$project['id'];

if (!isset($_FILES['file'])) json_out(['success' => false, 'message' => 'Missing file.'], 400);

$allowed = ['image/png'];
$projectDirAbs = UPLOAD_ROOT . "/projects/{$project_id}/exports";
ensure_dir($projectDirAbs);

$destAbs = $projectDirAbs . "/{$type}.png";
$move = move_uploaded_file_validated($_FILES['file'], $allowed, $destAbs);
if (!$move['ok']) json_out(['success' => false, 'message' => $move['message'] ?? 'Upload failed.'], 400);

$file_path = URL_UPLOADS_PREFIX . "/projects/{$project_id}/exports/{$type}.png";

// Optional: record in DB if project_exports exists
$tbl = $con->query("SHOW TABLES LIKE 'project_exports'");
if ($tbl && $tbl->num_rows > 0) {
  $stmt = $con->prepare("INSERT INTO project_exports (project_id, export_type, file_path) VALUES (?, ?, ?)");
  if ($stmt) {
    $stmt->bind_param('iss', $project_id, $type, $file_path);
    $stmt->execute();
    $stmt->close();
  }
}

json_out(['success' => true, 'file_path' => $file_path]);